/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextComponentTranslation;
import noppes.npcs.CustomNpcs;
import noppes.npcs.client.gui.util.GuiNpcTextField;
import noppes.npcs.client.gui.util.IComponentGui;
import noppes.npcs.client.gui.util.ICustomScrollListener;
import noppes.npcs.client.gui.util.IEditNPC;
import noppes.npcs.client.gui.util.IGuiCustomScroll;
import noppes.npcs.client.gui.util.IResourceData;
import noppes.npcs.util.NaturalOrderComparator;
import noppes.npcs.util.Util;
import org.lwjgl.input.Mouse;

public class GuiCustomScroll
extends GuiScreen
implements IComponentGui,
IGuiCustomScroll {
    public static ResourceLocation resource = new ResourceLocation("customnpcs", "textures/gui/misc.png");
    private ICustomScrollListener listener;
    public boolean hovered;
    public boolean isScrolling = false;
    public boolean selectable = true;
    public boolean visible = true;
    private boolean isSorted = true;
    private boolean multipleSelection = false;
    public int colorBack = -1072689136;
    public int border = -16777216;
    public int guiLeft = 0;
    public int guiTop = 0;
    public int hover = -1;
    public int id;
    private int lastClickedItem;
    private int listHeight = 0;
    public int maxScrollY;
    private int scrollHeight = 0;
    public int scrollY = 0;
    protected int selected = -1;
    private long lastClickedTime = 0L;
    private HashSet<String> selectedList = new HashSet();
    private final List<String> list = new ArrayList<String>();
    private List<Integer> colors = null;
    private List<String> suffixes;
    private List<ItemStack> stacks = null;
    private List<IResourceData> prefixes;
    private final Map<Integer, List<String>> hoversTexts = new TreeMap<Integer, List<String>>();
    private final List<String> hoverText = new ArrayList<String>();
    private final GuiNpcTextField textField = new GuiNpcTextField(0, null, 0, 0, 176, 16, "");
    private int listSize = 0;
    private boolean canSearch = true;
    private boolean hasSearch = false;
    private String searchString = "";
    private String[] searchWords = new String[0];

    public GuiCustomScroll(ICustomScrollListener parent, int scrollId) {
        this.id = scrollId;
        this.setParent(parent);
    }

    public GuiCustomScroll(ICustomScrollListener parent, boolean setSearch, int id) {
        this(parent, id);
        this.canSearch = setSearch;
    }

    public GuiCustomScroll(ICustomScrollListener parent, int id, boolean isMultipleSelection) {
        this(parent, id);
        this.multipleSelection = isMultipleSelection;
    }

    @Override
    public void canSearch(boolean setSearch) {
        this.canSearch = setSearch;
        this.reset();
    }

    @Override
    public void clear() {
        this.list.clear();
        this.selected = -1;
        this.scrollY = 0;
        this.searchString = "";
        this.searchWords = new String[0];
        this.textField.func_146180_a("");
        this.reset();
    }

    protected void drawItems() {
        int xOffset = this.scrollHeight <= this.field_146295_m - 6 ? 0 : 10;
        int displayIndex = 0;
        for (int i = 0; i < this.list.size(); ++i) {
            int c;
            if (!this.isSearched(this.list.get(i))) continue;
            int j = 4;
            int k = 14 * displayIndex + 4 - this.scrollY;
            ++displayIndex;
            if (k < 4 || k + 10 > this.field_146295_m) continue;
            String displayString = this.list.get(i) == null ? "null" : this.list.get(i);
            try {
                displayString = new TextComponentTranslation(displayString, new Object[0]).func_150254_d();
            }
            catch (Exception exception) {
                // empty catch block
            }
            StringBuilder text = new StringBuilder();
            float maxWidth = this.field_146294_l - xOffset - j - 2;
            if (this.stacks != null && !this.stacks.isEmpty() || this.prefixes != null && !this.prefixes.isEmpty()) {
                maxWidth -= 12.0f;
            }
            if (this.suffixes != null && i < this.suffixes.size() && !this.suffixes.get(i).isEmpty()) {
                maxWidth -= (float)(this.field_146289_q.func_78256_a(this.suffixes.get(i)) + 1);
            }
            if ((float)this.field_146289_q.func_78256_a(displayString) > maxWidth) {
                for (int s = 0; s < displayString.length(); ++s) {
                    if ((float)this.field_146289_q.func_78256_a(text + "...") > maxWidth) break;
                    c = displayString.charAt(s);
                    text.append((char)c);
                }
                text.append("...");
            } else {
                text = new StringBuilder(displayString);
            }
            int xo = 0;
            if (this.stacks != null && i < this.stacks.size() || this.prefixes != null && i < this.prefixes.size()) {
                j = 14;
                xo = -14;
            }
            c = CustomNpcs.MainColor.getRGB();
            if (this.colors != null && i < this.colors.size()) {
                c = this.colors.get(i);
            }
            if (this.multipleSelection && Util.instance.containsDeleteColor(this.selectedList, text.toString(), false) || !this.multipleSelection && this.selected == i) {
                int r = j + this.field_146294_l - 15 + xOffset + xo;
                this.func_73728_b(j - 2, k - 4, k + 10, -1);
                this.func_73728_b(r, k - 4, k + 10, -1);
                this.func_73730_a(j - 2, r, k - 3, -1);
                this.func_73730_a(j - 2, r, k + 10, -1);
                this.field_146289_q.func_78276_b(text.toString(), j, k, c);
                c = CustomNpcs.MainColor.getRGB();
            } else if (i == this.hover) {
                this.field_146289_q.func_78276_b(text.toString(), j, k, 65280);
                c = CustomNpcs.HoverColor.getRGB();
            } else {
                this.field_146289_q.func_78276_b(text.toString(), j, k, c);
                c = CustomNpcs.MainColor.getRGB();
            }
            if (this.suffixes == null || i >= this.suffixes.size() || this.suffixes.get(i) == null || this.suffixes.get(i).isEmpty() || this.field_146289_q.func_78256_a(text + this.suffixes.get(i)) >= this.field_146294_l - 20) continue;
            this.field_146289_q.func_78276_b(this.suffixes.get(i), this.field_146294_l - 11 - this.field_146289_q.func_78256_a(this.suffixes.get(i)), k, c);
        }
    }

    private void drawPrefixes() {
        if (this.prefixes == null) {
            return;
        }
        int displayIndex = 0;
        for (int i = 0; i < this.list.size() && i < this.prefixes.size(); ++i) {
            float scale;
            if (!this.isSearched(this.list.get(i))) continue;
            int k = 14 * displayIndex + 4 - this.scrollY;
            ++displayIndex;
            IResourceData rd = this.prefixes.get(i);
            if (k < 4 || k + 12 >= this.field_146295_m || rd == null || rd.getResource() == null || rd.getWidth() <= 0 || rd.getHeight() <= 0) continue;
            boolean hasStack = this.stacks != null && !this.stacks.isEmpty() && i < this.stacks.size();
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)this.guiLeft, (float)this.guiTop, (float)0.0f);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179109_b((float)(hasStack ? -13.0f : 0.5f), (float)((float)k - 1.5f + rd.getTextureHeight()), (float)0.0f);
            float scaleX = scale = 12.0f / (float)Math.max(rd.getWidth(), rd.getHeight());
            float scaleY = scale;
            if (rd.getScaleX() != 0.0f || rd.getScaleY() != 0.0f) {
                scaleX *= rd.getScaleX();
                scaleY *= rd.getScaleY();
                GlStateManager.func_179109_b((float)(12.0f * rd.getScaleX()), (float)(6.0f * rd.getScaleY()), (float)0.0f);
            }
            GlStateManager.func_179152_a((float)scaleX, (float)scaleY, (float)1.0f);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(rd.getResource());
            this.func_73729_b(0, 0, rd.getU(), rd.getV(), rd.getWidth(), rd.getHeight());
            GlStateManager.func_179121_F();
        }
    }

    @Override
    public void render(IEditNPC gui, int mouseX, int mouseY, float partialTicks) {
        if (!this.visible) {
            return;
        }
        this.hovered = this.isMouseOver(mouseX, mouseY);
        this.drawScreen(mouseX, mouseY, !gui.hasSubGui() && !gui.hasArea());
    }

    public void drawScreen(int mouseX, int mouseY, boolean canScrolled) {
        boolean parentAllows;
        if (this.hasSearch && this.listener instanceof IEditNPC) {
            this.textField.field_146209_f = this.guiLeft;
            this.textField.field_146210_g = this.guiTop;
            this.textField.render((IEditNPC)((Object)this.listener), mouseX, mouseY, 0.0f);
        }
        this.guiTop += this.textFieldHeight();
        if (this.border != -16777216) {
            this.func_73733_a(this.guiLeft - 1, this.guiTop - 1, this.field_146294_l + this.guiLeft + 1, this.field_146295_m + this.guiTop + 1, this.border, this.border);
        }
        if ((this.colorBack >> 24 & 0xFF) > 0) {
            this.func_73733_a(this.guiLeft, this.guiTop, this.field_146294_l + this.guiLeft, this.field_146295_m + this.guiTop, this.colorBack, this.colorBack);
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)this.guiLeft, (float)this.guiTop, (float)0.0f);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.selectable) {
            this.hover = this.getMouseOver(mouseX, mouseY);
        }
        this.drawItems();
        GlStateManager.func_179121_F();
        boolean bl = parentAllows = this.listener == null || !this.listener.hasSubGui();
        if (parentAllows) {
            if (this.stacks != null) {
                this.drawStacks();
            }
            if (this.prefixes != null) {
                this.drawPrefixes();
            }
        }
        if (this.scrollHeight <= this.field_146295_m - 6) {
            int dWheel;
            this.drawScrollBar();
            mouseY -= this.guiTop;
            if (this.isScrolling) {
                this.isScrolling = Mouse.isButtonDown((int)0);
                if (this.isScrolling) {
                    this.scrollY = (int)((float)mouseY / ((float)this.field_146295_m - 2.0f) * ((float)this.listHeight - (float)this.scrollHeight));
                    if (this.scrollY < 0) {
                        this.scrollY = 0;
                    }
                    if (this.scrollY > this.maxScrollY) {
                        this.scrollY = this.maxScrollY;
                    }
                }
            }
            if (canScrolled && this.hovered && (dWheel = Mouse.getDWheel()) != 0) {
                this.scrollY += dWheel > 0 ? -14 : 14;
                if (this.scrollY > this.maxScrollY) {
                    this.scrollY = this.maxScrollY;
                }
                if (this.scrollY < 0) {
                    this.scrollY = 0;
                }
            }
        }
        if (this.hover >= 0 && this.hover < this.list.size() && parentAllows && this.listener instanceof IEditNPC) {
            if (this.hoversTexts.containsKey(this.hover)) {
                ((IEditNPC)((Object)this.listener)).setHoverText(this.hoversTexts.get(this.hover));
            } else if (!this.hoverText.isEmpty()) {
                ((IEditNPC)((Object)this.listener)).setHoverText(this.hoverText);
            } else if (this.stacks != null && this.hover < this.stacks.size()) {
                ((IEditNPC)((Object)this.listener)).setHoverText(this.stacks.get(this.hover).func_82840_a((EntityPlayer)this.field_146297_k.field_71439_g, (ITooltipFlag)ITooltipFlag.TooltipFlags.NORMAL));
            }
        }
        this.guiTop -= this.textFieldHeight();
    }

    private void drawScrollBar() {
        int posX = this.guiLeft + this.field_146294_l - 9;
        int posY = this.guiTop + (int)((float)this.scrollY / (float)this.listHeight * ((float)this.field_146295_m - 2.0f)) + 1;
        Gui.func_73734_a((int)posX, (int)posY, (int)(posX + 8), (int)(posY + this.scrollHeight + 1), (int)-1593839376);
    }

    private void drawStacks() {
        if (this.stacks == null) {
            return;
        }
        int displayIndex = 0;
        for (int i = 0; i < this.list.size() && i < this.stacks.size(); ++i) {
            if (!this.isSearched(this.list.get(i))) continue;
            int k = 14 * displayIndex + 4 - this.scrollY;
            ++displayIndex;
            if (k < 4 || k + 10 > this.field_146295_m) continue;
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)this.guiLeft, (float)this.guiTop, (float)0.0f);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179109_b((float)0.0f, (float)((float)k - 2.5f), (float)300.0f);
            GlStateManager.func_179152_a((float)0.75f, (float)0.75f, (float)0.75f);
            RenderHelper.func_74520_c();
            this.field_146297_k.func_175599_af().func_180450_b(this.stacks.get(i), 0, 0);
            RenderHelper.func_74518_a();
            GlStateManager.func_179121_F();
        }
    }

    @Override
    public int getColor(int pos) {
        if (this.colors == null || this.colors.isEmpty()) {
            return 0;
        }
        return this.colors.get(pos);
    }

    @Override
    public int getHeight() {
        return this.field_146295_m;
    }

    @Override
    public void customKeyTyped(char c, int id) {
        this.func_73869_a(c, id);
    }

    @Override
    public void customMouseClicked(int mouseX, int mouseY, int mouseButton) {
        this.func_73864_a(mouseX, mouseY, mouseButton);
    }

    @Override
    public void customMouseReleased(int mouseX, int mouseY, int mouseButton) {
        this.func_146286_b(mouseX, mouseY, mouseButton);
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public void setIsVisible(boolean bo) {
        this.visible = bo;
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public void setEnabled(boolean bo) {
    }

    @Override
    public boolean isHovered() {
        return this.hovered;
    }

    @Override
    public List<String> getList() {
        return this.list;
    }

    private int getMouseOver(int mouseX, int mouseY) {
        if ((mouseX -= this.guiLeft) >= 4 && mouseX < this.field_146294_l - 4 && (mouseY -= this.guiTop) >= 4 && mouseY < this.field_146295_m) {
            int displayIndex = 0;
            for (int pos = 0; pos < this.list.size(); ++pos) {
                if (!this.isSearched(this.list.get(pos))) continue;
                if (this.mouseInOption(mouseX, mouseY, displayIndex)) {
                    return pos;
                }
                ++displayIndex;
            }
        }
        return -1;
    }

    @Override
    public String getSelected() {
        if (this.selected == -1 || this.selected >= this.list.size()) {
            return null;
        }
        return this.list.get(this.selected);
    }

    @Override
    public HashSet<String> getSelectedList() {
        return this.selectedList;
    }

    @Override
    public int getWidth() {
        return this.field_146294_l;
    }

    @Override
    public boolean hasSelected() {
        return this.selected >= 0 && this.getSelected() != null;
    }

    public boolean isMouseOver(int x, int y) {
        return x >= this.guiLeft && x <= this.guiLeft + this.field_146294_l && y >= this.guiTop && y <= this.guiTop + this.field_146295_m;
    }

    private boolean isSameList(List<String> checklist) {
        if (this.list.size() != checklist.size()) {
            return false;
        }
        for (int i = 0; i < checklist.size(); ++i) {
            String s = this.list.get(i);
            if (!checklist.contains(s)) {
                return false;
            }
            String l = checklist.get(i);
            if (s.equalsIgnoreCase(l)) continue;
            return false;
        }
        return true;
    }

    public void func_73869_a(char c, int i) {
        if (this.hasSearch) {
            boolean bo = this.textField.func_146201_a(c, i);
            if (!this.searchString.equals(this.textField.func_146179_b())) {
                this.searchString = this.textField.func_146179_b().trim();
                this.searchWords = this.searchString.split(" ");
                this.reset();
            }
            if (bo) {
                return;
            }
        }
        if (!this.hovered || GuiNpcTextField.isActive()) {
            return;
        }
        if (this.list.size() <= 1) {
            return;
        }
        if (i == 200 || i == this.field_146297_k.field_71474_y.field_74351_w.func_151463_i()) {
            if (this.selected < 1) {
                return;
            }
            --this.selected;
            if (this.maxScrollY > 0) {
                this.scrollY -= 14;
                if (this.scrollY < 0) {
                    this.scrollY = 0;
                }
            }
            if (this.listener != null) {
                this.listener.scrollClicked(-1, -1, 0, this);
            }
        } else if (i == 208 || i == this.field_146297_k.field_71474_y.field_74368_y.func_151463_i()) {
            if (this.selected >= this.getList().size() - 1) {
                return;
            }
            ++this.selected;
            if (this.maxScrollY > 0) {
                this.scrollY += 14;
                if (this.scrollY > this.maxScrollY) {
                    this.scrollY = this.maxScrollY;
                }
            }
            if (this.listener != null) {
                this.listener.scrollClicked(-1, -1, 0, this);
            }
        }
    }

    public void func_73864_a(int mouseX, int mouseY, int mouseButton) {
        if (this.hasSearch) {
            this.textField.func_146192_a(mouseX, mouseY, mouseButton);
        }
        if (this.scrollHeight < this.field_146295_m - 2) {
            double x = mouseX - this.guiLeft;
            double y = mouseY - this.guiTop;
            int h = this.field_146295_m;
            if (this.hasSearch && this.listener instanceof IEditNPC) {
                h += 19;
            }
            boolean bl = this.isScrolling = x >= (double)(this.field_146294_l - 10) && x < (double)(this.field_146294_l - 1) && y >= 1.0 && y < (double)(h - 2);
            if (this.isScrolling) {
                return;
            }
        }
        if (mouseButton != 0 || this.hover < 0) {
            return;
        }
        if (this.multipleSelection) {
            if (this.selectedList.contains(this.list.get(this.hover))) {
                this.selectedList.remove(this.list.get(this.hover));
            } else {
                this.selectedList.add(this.list.get(this.hover));
            }
        } else {
            this.selected = this.hover;
            this.hover = -1;
        }
        if (this.listener != null) {
            this.listener.scrollClicked(mouseX, mouseY, mouseButton, this);
        }
        long time = System.currentTimeMillis();
        if (this.listener != null && this.selected >= 0 && this.selected == this.lastClickedItem && time - this.lastClickedTime < 500L) {
            this.listener.scrollDoubleClicked(this.list.get(this.selected), this);
        }
        this.lastClickedTime = time;
        this.lastClickedItem = this.selected;
    }

    public boolean mouseInOption(int i, int j, int k) {
        int l = 4;
        int i2 = 14 * k + 4 - this.scrollY;
        return i >= l - 1 && i < l + this.field_146294_l - 11 && j >= i2 - 1 && j < i2 + 8;
    }

    public void replace(String oldName, String newName) {
        if (!this.list.contains(oldName)) {
            return;
        }
        String select = this.getSelected();
        int i = this.list.indexOf(oldName);
        this.list.remove(oldName);
        this.list.add(i, newName);
        if (this.isSorted) {
            this.list.sort(new NaturalOrderComparator());
        }
        if (oldName.equals(select)) {
            select = newName;
        }
        this.setSelected(select);
        this.reset();
    }

    @Override
    public void resetRoll() {
        if (this.selected <= 0) {
            return;
        }
        int pos = (this.selected + 1) * 14;
        if (pos >= this.scrollY && pos <= this.scrollY + this.field_146295_m) {
            return;
        }
        this.scrollY = pos;
        if (pos - this.field_146295_m / 2 > 0) {
            this.scrollY = pos - this.field_146295_m / 2;
        }
        if (this.scrollY < 0) {
            this.scrollY = 0;
        }
        if (this.scrollY > this.maxScrollY) {
            this.scrollY = this.maxScrollY;
        }
    }

    @Override
    public void scrollTo(String name) {
        int i = this.list.indexOf(name);
        if (i < 0 || this.scrollHeight >= this.field_146295_m - 2) {
            return;
        }
        int pos = (int)(1.0f * (float)i / (float)this.listSize * (float)this.listHeight);
        if (pos > this.maxScrollY) {
            pos = this.maxScrollY;
        }
        this.scrollY = pos;
    }

    @Override
    public void setColors(List<Integer> newColors) {
        this.colors = newColors;
    }

    @Override
    public void setList(List<String> newList) {
        if (newList == null) {
            newList = new ArrayList<String>();
        }
        if (this.isSameList(newList)) {
            return;
        }
        this.isSorted = true;
        newList.sort(new NaturalOrderComparator());
        this.list.clear();
        this.list.addAll(newList);
        this.searchString = "";
        this.listSize = this.list.size();
        this.reset();
    }

    @Override
    public void setListNotSorted(List<String> newList) {
        if (this.isSameList(newList)) {
            return;
        }
        this.list.clear();
        this.list.addAll(newList);
        this.searchString = "";
        this.listSize = this.list.size();
        this.isSorted = false;
        this.reset();
    }

    @Override
    public void setPrefixes(List<IResourceData> newPrefixes) {
        this.prefixes = newPrefixes;
    }

    @Override
    public boolean hasSelected(String name) {
        if (name == null || name.isEmpty()) {
            return false;
        }
        if (this.list.contains(name)) {
            return true;
        }
        name = Util.instance.deleteColor(name);
        for (String s : this.list) {
            if (!Util.instance.deleteColor(s).equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setSelected(String name) {
        if (name == null || name.isEmpty()) {
            this.selected = -1;
        }
        this.selected = this.list.indexOf(name);
        if (this.selected == -1) {
            name = Util.instance.deleteColor(name);
            for (int i = 0; i < this.list.size(); ++i) {
                if (!Util.instance.deleteColor(this.list.get(i)).equalsIgnoreCase(name)) continue;
                this.selected = i;
                break;
            }
        }
        this.resetRoll();
    }

    @Override
    public void setSelectedList(HashSet<String> newSelectedList) {
        newSelectedList.removeIf(line -> !this.list.contains(line));
        this.selectedList = newSelectedList;
    }

    @Override
    public void setSize(int w, int h) {
        this.textField.field_146218_h = w;
        this.field_146295_m = h - this.textFieldHeight();
        this.field_146294_l = w;
        this.listHeight = 14 * this.listSize;
        this.scrollHeight = this.listHeight > 0 ? (int)Math.floor((float)this.field_146295_m * ((float)this.field_146295_m - 2.0f) / (float)this.listHeight) : Integer.MAX_VALUE;
        this.maxScrollY = this.listHeight - this.field_146295_m;
        if (this.maxScrollY < 0) {
            this.maxScrollY = 0;
        }
        if (this.maxScrollY > 0 && this.scrollY > this.maxScrollY || this.maxScrollY == 0) {
            this.scrollY = 0;
        }
    }

    private int textFieldHeight() {
        return this.hasSearch ? this.textField.field_146219_i + 2 : 0;
    }

    private void reset() {
        int h = this.textFieldHeight();
        boolean bl = this.hasSearch = this.canSearch && this.list.size() > 9;
        if (this.hasSearch) {
            this.listSize = this.searchString.isEmpty() ? this.list.size() : (int)this.list.stream().filter(this::isSearched).count();
        } else {
            this.searchString = "";
            this.searchWords = new String[0];
            this.textField.func_146180_a("");
        }
        this.setSize(this.field_146294_l, this.field_146295_m + h);
    }

    private boolean isSearched(String s) {
        try {
            s = new TextComponentTranslation(s, new Object[0]).func_150254_d();
        }
        catch (Exception exception) {
            // empty catch block
        }
        s = Util.instance.deleteColor(s);
        for (String k : this.searchWords) {
            if (s.toLowerCase().contains(Util.instance.deleteColor(k).toLowerCase())) continue;
            return false;
        }
        return true;
    }

    @Override
    public void setStacks(List<ItemStack> newStacks) {
        this.stacks = newStacks;
    }

    @Override
    public void setSuffixes(List<String> newSuffixes) {
        this.suffixes = newSuffixes;
    }

    @Override
    public IGuiCustomScroll setUnSelectable() {
        this.selectable = false;
        return this;
    }

    @Override
    public int getID() {
        return this.id;
    }

    @Override
    public int[] getCenter() {
        return new int[]{this.guiLeft + this.field_146294_l / 2, this.guiTop + this.field_146295_m / 2};
    }

    @Override
    public void setHoverText(String text, Object ... args) {
        this.hoverText.clear();
        if (text == null || text.isEmpty()) {
            return;
        }
        if (!text.contains("%")) {
            text = new TextComponentTranslation(text, args).func_150254_d();
        }
        if (text.contains("~~~")) {
            text = text.replaceAll("~~~", "%");
        }
        while (text.contains("<br>")) {
            this.hoverText.add(text.substring(0, text.indexOf("<br>")));
            text = text.substring(text.indexOf("<br>") + 4);
        }
        this.hoverText.add(text);
    }

    @Override
    public void setHoverTexts(LinkedHashMap<Integer, List<String>> map) {
        this.hoversTexts.clear();
        if (map == null || map.isEmpty()) {
            return;
        }
        this.hoversTexts.putAll(map);
    }

    @Override
    @Nonnull
    public Map<Integer, List<String>> getHoversTexts() {
        return this.hoversTexts;
    }

    @Override
    @Nonnull
    public List<String> getHoversText() {
        return this.hoverText;
    }

    @Override
    public int getLeft() {
        return this.guiLeft;
    }

    @Override
    public int getTop() {
        return this.guiTop;
    }

    @Override
    public void setLeft(int left) {
        this.guiLeft = left;
    }

    @Override
    public void setTop(int top) {
        this.guiTop = top;
    }

    @Override
    public void setParent(ICustomScrollListener parent) {
        this.listener = parent;
    }

    @Override
    public int getSelect() {
        return this.selected;
    }

    @Override
    public void setSelect(int slotIndex) {
        if (slotIndex < 0) {
            this.selected = -1;
        }
        if (slotIndex >= this.list.size()) {
            return;
        }
        this.selected = slotIndex;
    }
}

